#pragma once

#include <maps/libs/log8/include/log8.h>
#include <maps/libs/common/include/profiletimer.h>

#include <string>
#include <sstream>


namespace maps::mrc::browser {

class TimeProfiler
{
public:
    TimeProfiler(std::string name, int64_t thresholdMSec)
        : name_(std::move(name))
        , thresholdMSec_(thresholdMSec)
    {}

    ~TimeProfiler()
    {
        int64_t elapsedMSec = std::lround(timer_.getElapsedTimeNumber() * 1000);

        if (elapsedMSec > thresholdMSec_) {
            WARN() << "Timer '" << name_ << "' "
                << stream_.str() << " took " << elapsedMSec << " msec";
        }
    }

    template <class T>
    TimeProfiler& operator <<(T&& data) {
        stream_ << data;
        return *this;
    }

private:
    const std::string name_;
    std::stringstream stream_;
    const int64_t thresholdMSec_;
    ProfileTimer timer_;
};


} // namespace maps::mrc::browser
