#include "types.h"

#include <ostream>

namespace maps::mrc::browser {

std::ostream& operator<<(std::ostream& out, const PanoCutParams& cutParams)
{
    out << cutParams.totalWidth << "," << cutParams.totalHeight << ","
        << cutParams.tileWidth << "," << cutParams.tileHeight << ","
        << cutParams.zoomLevel;
    return out;
}

std::ostream& operator<<(std::ostream& out, const PanoCropOut& cropOut)
{
    out << cropOut.x << "," << cropOut.y << ","
        << cropOut.width << "," << cropOut.height << ","
        << cropOut.scale;
    return out;
}

} // namespace maps::mrc::browser
