OWNER(g:maps-mrc)

LIBRARY()

ADDINCL(
    contrib/libs/opencv/include
)

PEERDIR(
    contrib/restricted/boost/libs
    contrib/libs/opencv
    contrib/libs/libpqxx
    maps/doc/proto/converters/geolib
    maps/doc/proto/yandex/maps/proto/mobile_config/mapkit2
    maps/doc/proto/yandex/maps/proto/mrcphoto
    maps/analyzer/libs/graphmatching
    maps/infra/yacare
    maps/libs/chrono
    maps/libs/common
    maps/libs/concurrent
    maps/libs/geolib
    maps/libs/http
    maps/libs/json
    maps/libs/introspection
    maps/libs/log8
    maps/libs/mds-client
    maps/libs/pgpool
    maps/libs/pgpool3utils
    maps/libs/spatial
    maps/libs/sproto
    maps/libs/tile
    maps/renderer/libs/data_sets/postgis_data_set
    maps/renderer/libs/design
    maps/renderer/libs/style2_renderer
    maps/renderer/rapidjson-helper
    maps/wikimap/mapspro/libs/common
    maps/wikimap/mapspro/services/mrc/browser/lib/proto
    maps/wikimap/mapspro/services/mrc/libs/blackbox_client
    maps/wikimap/mapspro/services/mrc/libs/common
    maps/wikimap/mapspro/services/mrc/libs/db
    maps/wikimap/mapspro/services/mrc/libs/object
    maps/wikimap/mapspro/services/mrc/libs/fb
    maps/wikimap/mapspro/services/mrc/libs/privacy
    maps/wikimap/mapspro/services/mrc/libs/proto
    maps/wikimap/mapspro/services/mrc/libs/ugc_event_logger
)

SRCS(
    data_access_db.cpp
    data_access_fb.cpp
    design_registry.cpp
    error_reporter.cpp
    GLOBAL feature_api.cpp
    feature_author.cpp
    graph.cpp
    graph_coverage_explorer.cpp
    GLOBAL panorama_api.cpp
    GLOBAL photo_api.cpp
    permission_checker.cpp
    GLOBAL service_api.cpp
    tile_renderer.cpp
    tools.cpp
    undistort.cpp
)

GENERATE_ENUM_SERIALIZATION(maps/wikimap/mapspro/services/mrc/libs/db/include/common.h)

RESOURCE(
    design/mrc_age.json mrc_age.json
    design/mrc_age_p.json mrc_age_p.json
    design/mrc_age_r.json mrc_age_r.json
    design/mrce_cov.json mrce_cov.json
    design/mrcpent.json mrcpent.json
    design/mrcss.json mrcss.json
)

END()
