--
-- PostgreSQL database dump
--

-- Dumped from database version 9.5.3
-- Dumped by pg_dump version 9.5.3

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;
SET row_security = off;


CREATE SCHEMA acl;

SET search_path = acl, pg_catalog;

CREATE TYPE ban_record_action_type AS ENUM (
    'ban',
    'unban'
);


--
-- Name: user_status_type; Type: TYPE; Schema: acl;
--

CREATE TYPE user_status_type AS ENUM (
    'active',
    'deleted'
);


--
-- Name: on_delete_group_trigger(); Type: FUNCTION; Schema: acl;
--

CREATE FUNCTION on_delete_group_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$BEGIN
DELETE FROM acl.policy WHERE agent_id=OLD.id;
RETURN NULL;
END;$$;


--
-- Name: on_delete_role_trigger(); Type: FUNCTION; Schema: acl;
--

CREATE FUNCTION on_delete_role_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$BEGIN
DELETE FROM acl.policy WHERE role_id=old.id;
RETURN NULL;
END;$$;


--
-- Name: recently_unbanned_users(date, interval); Type: FUNCTION; Schema: acl;
--

CREATE FUNCTION recently_unbanned_users(today date, unban_interval interval) RETURNS TABLE(uid bigint)
    LANGUAGE sql
    AS $$
  SELECT uid
  FROM acl.user
  JOIN acl.ban_record ON current_ban_id = br_id
  WHERE
    (br_action = 'unban' AND br_created < today AND br_created > today - unban_interval) OR
    (br_action = 'ban' AND br_expires < today AND br_expires > today - unban_interval)
$$;



SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: agent; Type: TABLE; Schema: acl;
--

CREATE TABLE agent (
    id bigint NOT NULL
);


--
-- Name: agent_id_seq; Type: SEQUENCE; Schema: acl;
--

CREATE SEQUENCE agent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: agent_id_seq; Type: SEQUENCE OWNED BY; Schema: acl;
--

ALTER SEQUENCE agent_id_seq OWNED BY agent.id;


--
-- Name: ban_record; Type: TABLE; Schema: acl;
--

CREATE TABLE ban_record (
    br_id bigint NOT NULL,
    br_uid bigint NOT NULL,
    br_action ban_record_action_type NOT NULL,
    br_created timestamp with time zone DEFAULT now() NOT NULL,
    br_created_by bigint NOT NULL,
    br_expires timestamp with time zone,
    br_reason text
);


--
-- Name: ban_record_br_id_seq; Type: SEQUENCE; Schema: acl;
--

CREATE SEQUENCE ban_record_br_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ban_record_br_id_seq; Type: SEQUENCE OWNED BY; Schema: acl;
--

ALTER SEQUENCE ban_record_br_id_seq OWNED BY ban_record.br_id;


--
-- Name: group; Type: TABLE; Schema: acl;
--

CREATE TABLE "group" (
    name text NOT NULL
)
INHERITS (agent);



--
-- Name: group_user; Type: TABLE; Schema: acl;
--

CREATE TABLE group_user (
    group_id bigint NOT NULL,
    user_id bigint NOT NULL
);


--
-- Name: permission; Type: TABLE; Schema: acl;
--

CREATE TABLE permission (
    id bigint NOT NULL,
    name text NOT NULL,
    parent_id bigint
);



--
-- Name: permission_id_seq; Type: SEQUENCE; Schema: acl;
--

CREATE SEQUENCE permission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;



--
-- Name: permission_id_seq; Type: SEQUENCE OWNED BY; Schema: acl;
--

ALTER SEQUENCE permission_id_seq OWNED BY permission.id;


--
-- Name: policy; Type: TABLE; Schema: acl;
--

CREATE TABLE policy (
    agent_id bigint NOT NULL,
    role_id bigint NOT NULL,
    aoi_id bigint DEFAULT 0 NOT NULL
);



--
-- Name: restricted_users; Type: TABLE; Schema: acl;
--

CREATE TABLE restricted_users (
    id bigint NOT NULL,
    uid bigint NOT NULL,
    restricted_at timestamp with time zone DEFAULT now() NOT NULL,
    restriction_reason text NOT NULL
);



--
-- Name: restricted_users_id_seq; Type: SEQUENCE; Schema: acl;
--

CREATE SEQUENCE restricted_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;



--
-- Name: restricted_users_id_seq; Type: SEQUENCE OWNED BY; Schema: acl;
--

ALTER SEQUENCE restricted_users_id_seq OWNED BY restricted_users.id;


--
-- Name: role; Type: TABLE; Schema: acl;
--

CREATE TABLE role (
    id bigint NOT NULL,
    name text NOT NULL
);



--
-- Name: role_id_seq; Type: SEQUENCE; Schema: acl;
--

CREATE SEQUENCE role_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;



--
-- Name: role_id_seq; Type: SEQUENCE OWNED BY; Schema: acl;
--

ALTER SEQUENCE role_id_seq OWNED BY role.id;


--
-- Name: role_permission; Type: TABLE; Schema: acl;
--

CREATE TABLE role_permission (
    role_id bigint NOT NULL,
    permission_id bigint NOT NULL
);



--
-- Name: user; Type: TABLE; Schema: acl;
--

CREATE TABLE "user" (
    uid bigint NOT NULL,
    login text NOT NULL,
    created timestamp with time zone DEFAULT now(),
    created_by bigint NOT NULL,
    modified timestamp with time zone DEFAULT now(),
    modified_by bigint NOT NULL,
    status user_status_type DEFAULT 'active'::user_status_type NOT NULL,
    current_ban_id bigint
)
INHERITS (agent);



--
-- Name: id; Type: DEFAULT; Schema: acl;
--

ALTER TABLE ONLY agent ALTER COLUMN id SET DEFAULT nextval('agent_id_seq'::regclass);


--
-- Name: br_id; Type: DEFAULT; Schema: acl;
--

ALTER TABLE ONLY ban_record ALTER COLUMN br_id SET DEFAULT nextval('ban_record_br_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: acl;
--

ALTER TABLE ONLY "group" ALTER COLUMN id SET DEFAULT nextval('agent_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: acl;
--

ALTER TABLE ONLY permission ALTER COLUMN id SET DEFAULT nextval('permission_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: acl;
--

ALTER TABLE ONLY restricted_users ALTER COLUMN id SET DEFAULT nextval('restricted_users_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: acl;
--

ALTER TABLE ONLY role ALTER COLUMN id SET DEFAULT nextval('role_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: acl;
--

ALTER TABLE ONLY "user" ALTER COLUMN id SET DEFAULT nextval('agent_id_seq'::regclass);


--
-- Name: agent_pkey; Type: CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY agent
    ADD CONSTRAINT agent_pkey PRIMARY KEY (id);


--
-- Name: ban_record_pkey; Type: CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY ban_record
    ADD CONSTRAINT ban_record_pkey PRIMARY KEY (br_id);


--
-- Name: group_pkey; Type: CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY "group"
    ADD CONSTRAINT group_pkey PRIMARY KEY (id);


--
-- Name: group_user_pkey; Type: CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY group_user
    ADD CONSTRAINT group_user_pkey PRIMARY KEY (group_id, user_id);


--
-- Name: permission_pkey; Type: CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY permission
    ADD CONSTRAINT permission_pkey PRIMARY KEY (id);


--
-- Name: restricted_users_pkey; Type: CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY restricted_users
    ADD CONSTRAINT restricted_users_pkey PRIMARY KEY (id);


--
-- Name: role_name_uniq; Type: CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY role
    ADD CONSTRAINT role_name_uniq UNIQUE (name);


--
-- Name: role_pkey; Type: CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY role
    ADD CONSTRAINT role_pkey PRIMARY KEY (id);


--
-- Name: roles_permissions_pkey; Type: CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY role_permission
    ADD CONSTRAINT roles_permissions_pkey PRIMARY KEY (role_id, permission_id);


--
-- Name: user_pkey; Type: CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY "user"
    ADD CONSTRAINT user_pkey PRIMARY KEY (id);


--
-- Name: ban_record_created_idx; Type: INDEX; Schema: acl;
--

CREATE INDEX ban_record_created_idx ON ban_record USING btree (br_created DESC);


--
-- Name: ban_record_uid_created_idx; Type: INDEX; Schema: acl;
--

CREATE INDEX ban_record_uid_created_idx ON ban_record USING btree (br_uid, br_created DESC);


--
-- Name: fki_group_user_group_foreign_key; Type: INDEX; Schema: acl;
--

CREATE INDEX fki_group_user_group_foreign_key ON group_user USING btree (group_id);


--
-- Name: fki_group_user_user_foreign_key; Type: INDEX; Schema: acl;
--

CREATE INDEX fki_group_user_user_foreign_key ON group_user USING btree (user_id);


--
-- Name: fki_role_permission_permission_foreign_key; Type: INDEX; Schema: acl;
--

CREATE INDEX fki_role_permission_permission_foreign_key ON role_permission USING btree (permission_id);


--
-- Name: fki_role_permission_role_foreign_key; Type: INDEX; Schema: acl;
--

CREATE INDEX fki_role_permission_role_foreign_key ON role_permission USING btree (role_id);


--
-- Name: group_name_idx; Type: INDEX; Schema: acl;
--

CREATE UNIQUE INDEX group_name_idx ON "group" USING btree (name);


--
-- Name: permission_parent_id_idx; Type: INDEX; Schema: acl;
--

CREATE INDEX permission_parent_id_idx ON permission USING btree (parent_id);


--
-- Name: permission_parent_id_name_idx; Type: INDEX; Schema: acl;
--

CREATE UNIQUE INDEX permission_parent_id_name_idx ON permission USING btree (parent_id, name);


--
-- Name: policy_agent_index; Type: INDEX; Schema: acl;
--

CREATE INDEX policy_agent_index ON policy USING btree (agent_id);


--
-- Name: policy_agent_role_aoi_idx; Type: INDEX; Schema: acl;
--

CREATE UNIQUE INDEX policy_agent_role_aoi_idx ON policy USING btree (agent_id, role_id, aoi_id);


--
-- Name: policy_aoi_index; Type: INDEX; Schema: acl;
--

CREATE INDEX policy_aoi_index ON policy USING btree (aoi_id);


--
-- Name: policy_role_index; Type: INDEX; Schema: acl;
--

CREATE INDEX policy_role_index ON policy USING btree (role_id);


--
-- Name: restricted_users_uid_idx; Type: INDEX; Schema: acl;
--

CREATE UNIQUE INDEX restricted_users_uid_idx ON restricted_users USING btree (uid);


--
-- Name: user_current_ban_id_idx; Type: INDEX; Schema: acl;
--

CREATE INDEX user_current_ban_id_idx ON "user" USING btree (current_ban_id);


--
-- Name: user_login_idx; Type: INDEX; Schema: acl;
--

CREATE UNIQUE INDEX user_login_idx ON "user" USING btree (login);


--
-- Name: user_login_trgm_idx; Type: INDEX; Schema: acl;
--

--CREATE INDEX user_login_trgm_idx ON "user" USING gin (login public.gin_trgm_ops) WITH (fastupdate=off);


--
-- Name: user_modified_login_idx; Type: INDEX; Schema: acl;
--

CREATE INDEX user_modified_login_idx ON "user" USING btree (modified DESC, login);


--
-- Name: user_uid_idx; Type: INDEX; Schema: acl;
--

CREATE UNIQUE INDEX user_uid_idx ON "user" USING btree (uid);


--
-- Name: on_delete_group; Type: TRIGGER; Schema: acl;
--

CREATE TRIGGER on_delete_group AFTER DELETE ON "group" FOR EACH ROW EXECUTE PROCEDURE on_delete_group_trigger();


--
-- Name: on_delete_role; Type: TRIGGER; Schema: acl;
--

CREATE TRIGGER on_delete_role AFTER DELETE ON role FOR EACH ROW EXECUTE PROCEDURE on_delete_role_trigger();


--
-- Name: ban_record_br_created_by_fkey; Type: FK CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY ban_record
    ADD CONSTRAINT ban_record_br_created_by_fkey FOREIGN KEY (br_created_by) REFERENCES "user"(uid);


--
-- Name: ban_record_br_uid_fkey; Type: FK CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY ban_record
    ADD CONSTRAINT ban_record_br_uid_fkey FOREIGN KEY (br_uid) REFERENCES "user"(uid);


--
-- Name: group_user_group_foreign_key; Type: FK CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY group_user
    ADD CONSTRAINT group_user_group_foreign_key FOREIGN KEY (group_id) REFERENCES "group"(id) ON DELETE CASCADE;


--
-- Name: group_user_user_foreign_key; Type: FK CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY group_user
    ADD CONSTRAINT group_user_user_foreign_key FOREIGN KEY (user_id) REFERENCES "user"(id) ON DELETE CASCADE;


--
-- Name: role_permission_permission_foreign_key; Type: FK CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY role_permission
    ADD CONSTRAINT role_permission_permission_foreign_key FOREIGN KEY (permission_id) REFERENCES permission(id) ON DELETE CASCADE;


--
-- Name: role_permission_role_foreign_key; Type: FK CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY role_permission
    ADD CONSTRAINT role_permission_role_foreign_key FOREIGN KEY (role_id) REFERENCES role(id) ON DELETE CASCADE;


--
-- Name: user_current_ban_id_fkey; Type: FK CONSTRAINT; Schema: acl;
--

ALTER TABLE ONLY "user"
    ADD CONSTRAINT user_current_ban_id_fkey FOREIGN KEY (current_ban_id) REFERENCES ban_record(br_id);


--
-- PostgreSQL database dump complete
--

