#include "common.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>

#include <maps/libs/process/include/process.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::mrc::browser::tests {


void validateJson(const std::string& jsonPath, const std::string& schemaPath)
{
    std::ostringstream cmd;
    cmd << BinaryPath("maps/tools/json-validator/json-validator")
        << " -i " << jsonPath
        << " -s " << schemaPath;

    auto proc = process::runInteractive(
        process::Command(
            {"/bin/sh", "-c", cmd.str()}
        )
    );

    EXPECT_EQ(proc.syncWait().exitStatus(), 0)
        << "json string '" << jsonPath << "' does not correspond to schema '"
        << schemaPath << "': " << proc.outputStream().rdbuf() << " "
        << proc.errorsStream().rdbuf();
}

std::string dataPath(const std::string& relativePath)
{
    return ArcadiaSourceRoot() + "/maps/wikimap/mapspro/services/mrc/browser/" + relativePath;
}

std::string apiResponseSchemaPath(const std::string& relativePath)
{
    return ArcadiaSourceRoot() + "/maps/wikimap/mapspro/schemas/mrc/" + relativePath;
}

std::string layerDataSchemaPath(const std::string& layer)
{
    return ArcadiaSourceRoot() + "/maps/doc/schemas/renderer/source/sources/" + layer + "/0.x/source.json";
}

void setFeaturesPrivacy(pgpool3::Pool& pool, db::FeaturePrivacy privacy) {
    auto txn = pool.masterWriteableTransaction();
    db::FeatureGateway gtw{*txn};
    auto features = gtw.load();
    for (auto& f : features) {
        f.setPrivacy(privacy);
    }
    gtw.update(features, db::UpdateFeatureTxn::No);
    txn->commit();
}

fb::PhotoToEdgePair makeRelation(db::TId featureId)
{
    static const auto edgeId = 1;
    static const auto begin = fb::PolylinePosition(0, 0.);
    static const auto end = fb::PolylinePosition(0, 1.);
    static const auto order = 0;
    return fb::PhotoToEdgePair(featureId, edgeId, begin, end, order);
}

} // namespace maps::mrc::browser::tests
