#include "fixture.h"
#include <maps/wikimap/mapspro/services/mrc/libs/ugc_event_logger/include/logger.h>

#include <maps/libs/common/include/file_utils.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/http/include/test_utils.h>

#include <chrono>
#include <memory>
#include <thread>

namespace maps::mrc::browser::tests {

namespace {

chrono::TimePoint constGetCurrentTimestamp() {
    return chrono::TimePoint(chrono::TimePoint::duration(0));
};


class ReplaceUgcLoggerFixture : public UserMayViewPhotosFixture<true> {
public:
    ReplaceUgcLoggerFixture(const std::string& logPath)
    : ugcLogPath(logPath)
    , ugcEventLogger(new ugc_event_logger::Logger(ugcLogPath, std::chrono::seconds(600), constGetCurrentTimestamp))
    {
        browser::Configuration::instance()->setUgcEventLogger(ugcEventLogger);
    }

    std::string finishUgcLogAndGetContents()
    {
        browser::Configuration::instance()->setUgcEventLogger({});
        ugcEventLogger.reset();
        return maps::common::readFileToString(ugcLogPath);
    }

    std::string ugcLogPath;
    std::shared_ptr<ugc_event_logger::Logger> ugcEventLogger;
};


} // namespace

Y_UNIT_TEST_SUITE(log_ugc_events_should) {

Y_UNIT_TEST(feature_api_unauthorized_test)
{
    ReplaceUgcLoggerFixture fixture("feature_api_unauthorized_test.log");

    std::vector<http::MockRequest> requests {
        {http::GET, http::URL("http://localhost/feature/1/image")},
        {http::GET, http::URL("http://localhost/feature/1/thumbnail")},
        {http::GET, http::URL("http://localhost/feature/1/undistorted")},
        {http::GET, http::URL("http://localhost/v2/photo/get")
                .addParam("l", "mrcpdst")
                .addParam("id", "5")
                .addParam("z", "17") },
        {http::GET, http::URL("http://localhost/v2/photos/get")
                .addParam("l", "mrcpdst")
                .addParam("ids", "6,7")
                .addParam("z", "17") },
    };

    for (const auto& request : requests) {
        auto resp = yacare::performTestRequest(request);
        EXPECT_EQ(resp.status, 200);
    }

    const std::string EXPECTED_LOG =
R"({"timestamp":"0","user":{"ip":"127.0.0.1"},"object":{"type":"photo","id":"1"},"action":"view"}
{"timestamp":"0","user":{"ip":"127.0.0.1"},"object":{"type":"photo","id":"1"},"action":"view"}
{"timestamp":"0","user":{"ip":"127.0.0.1"},"object":{"type":"photo","id":"1"},"action":"view"}
{"timestamp":"0","user":{"ip":"127.0.0.1"},"object":{"type":"photo","id":"5"},"action":"view"}
{"timestamp":"0","user":{"ip":"127.0.0.1"},"object":{"type":"photo","id":"6"},"action":"view"}
{"timestamp":"0","user":{"ip":"127.0.0.1"},"object":{"type":"photo","id":"7"},"action":"view"}
)";

    EXPECT_EQ(fixture.finishUgcLogAndGetContents(), EXPECTED_LOG);
}

Y_UNIT_TEST(feature_api_authorized_test)
{
    ReplaceUgcLoggerFixture fixture("feature_api_authorized_test.log");

    std::vector<http::MockRequest> requests {
        {http::GET, http::URL("http://localhost/feature/1/image")},
        {http::GET, http::URL("http://localhost/feature/1/thumbnail")},
        {http::GET, http::URL("http://localhost/feature/1/undistorted")},
        {http::GET, http::URL("http://localhost/v2/photo/get")
                .addParam("l", "mrcpdst")
                .addParam("id", "5")
                .addParam("z", "17") },
        {http::GET, http::URL("http://localhost/v2/photos/get")
                .addParam("l", "mrcpdst")
                .addParam("ids", "6,7")
                .addParam("z", "17") },
    };

    for (auto& request : requests) {
        request.headers.emplace(yacare::tests::USER_ID_HEADER, std::to_string(fixture.UID));
        auto resp = yacare::performTestRequest(request);
        EXPECT_EQ(resp.status, 200);
    }

    const std::string EXPECTED_LOG =
R"({"timestamp":"0","user":{"ip":"127.0.0.1","uid":"1"},"object":{"type":"photo","id":"1"},"action":"view"}
{"timestamp":"0","user":{"ip":"127.0.0.1","uid":"1"},"object":{"type":"photo","id":"1"},"action":"view"}
{"timestamp":"0","user":{"ip":"127.0.0.1","uid":"1"},"object":{"type":"photo","id":"1"},"action":"view"}
{"timestamp":"0","user":{"ip":"127.0.0.1","uid":"1"},"object":{"type":"photo","id":"5"},"action":"view"}
{"timestamp":"0","user":{"ip":"127.0.0.1","uid":"1"},"object":{"type":"photo","id":"6"},"action":"view"}
{"timestamp":"0","user":{"ip":"127.0.0.1","uid":"1"},"object":{"type":"photo","id":"7"},"action":"view"}
)";

    EXPECT_EQ(fixture.finishUgcLogAndGetContents(), EXPECTED_LOG);
}

} // Y_UNIT_TEST_SUITE(log_ugc_events_should)

} // namespace maps::mrc::browser::tests
