#pragma once

#include <maps/wikimap/mapspro/services/mrc/browser/lib/graph.h>
#include <maps/wikimap/mapspro/services/mrc/browser/lib/permission_checker.h>

#include <maps/wikimap/mapspro/services/mrc/libs/privacy/tests/mocks/region_privacy.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

#include <memory>

namespace maps::mrc::browser::tests {

struct MockGraph: IGraph {

    MOCK_METHOD(const road_graph::Graph&, graph, (), (const, override));
    MOCK_METHOD(const succinct_rtree::Rtree&, rtree, (), (const, override));
    MOCK_METHOD(const road_graph::PersistentIndex&, persistentIndex, (), (const, override));

    MOCK_METHOD(
        std::vector<fb::CoveredSubPolyline>,
        getCoveredSubpolylinesForEdgeSegments,
        (road_graph::EdgeId,
            const std::vector<road_graph::SegmentIndex>& sortedSegments,
            db::CameraDeviation,
            db::FeaturePrivacy),
        (const, override));

    MOCK_METHOD(
        std::vector<road_graph::EdgeId>,
        getCoveredEdgeIdsByBbox,
        (const geolib3::BoundingBox&, db::TFc),
        (const, override));

    MOCK_METHOD(
        std::vector<road_graph::EdgeId>,
        getNearestCoveredEdges,
        (const geolib3::Point2&, size_t, db::TFc),
        (const, override));

    MOCK_METHOD(db::TIds, getFeatureIdsByBbox, (const geolib3::BoundingBox&), (const, override));
    MOCK_METHOD(db::TIds, getFeatureIdsByEdgeId, (road_graph::EdgeId), (const, override));

    MOCK_METHOD(
        std::optional<fb::TEdge>,
        getCoveredEdgeById,
        (road_graph::EdgeId),
        (const, override));

    MOCK_METHOD(
        std::size_t,
        getEdgeSegmentsNum,
        (road_graph::EdgeId),
        (const, override));

    MOCK_METHOD(
        std::optional<chrono::TimePoint>,
        getGeneratedAt,
        (),
        (const, override));
};

struct MockPhotoToEdge: IPhotoToEdge {

    MOCK_METHOD(
        std::vector<fb::PhotoToEdgePair>,
        lookupByFeatureId,
        (db::TId),
        (const, override));

    MOCK_METHOD(
        std::optional<chrono::TimePoint>,
        getGeneratedAt,
        (),
        (const, override));
};

struct MockBlackboxClient: blackbox_client::IBlackboxClient {
    MOCK_METHOD(std::optional<blackbox_client::Uid>,
                uidByLogin,
                (const std::string&),
                (const, override));
    MOCK_METHOD(blackbox_client::UidToLoginMap,
                uidToLoginMap,
                (blackbox_client::Uids),
                (const, override));
    MOCK_METHOD(blackbox_client::UidToUserInfoMap,
                uidToUserInfoMap,
                (blackbox_client::Uids, const blackbox_client::QueryParams&),
                (const, override));
};

struct MockPermissionChecker: IPermissionChecker {
    MOCK_METHOD(bool, userMayViewPhotos, (std::optional<Uid>, db::FeaturePrivacy), (override));
};

inline auto makeMockPermissionChecker() { return std::make_unique<MockPermissionChecker>(); }

} // namespace maps::mrc::browser::tests
