#!/usr/bin/env python3

import argparse
from firmware_signature import get_firmware_signature


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--key', type=str, required=True, help='Key string')
    parser.add_argument('--url', type=str, required=True, help='Url to encrypt')
    parser.add_argument('--user-agent', type=str, required=True, help='User agent')

    args = parser.parse_args()
    print(get_firmware_signature(args.user_agent, args.url, args.key))
