from urllib.parse import urlparse
import hmac
import hashlib


def get_firmware_signature(user_agent, url, key):
    parsed_url = urlparse(url)
    contents = [user_agent, parsed_url.hostname, 'GET', parsed_url.path + parsed_url.query, '']

    digest_maker = hmac.new(key.encode(), ''.encode(), hashlib.sha1)
    for cont in contents:
        digest_maker.update(cont.encode())
    return digest_maker.hexdigest()
