import logging
import subprocess
import tarfile

logger = logging.getLogger('mrc-drive-updater')


def run_command(command):
    """Run shell command. Return True is its return code is 0, otherwise return False"""

    result = subprocess.run(command)

    if result.returncode != 0:
        logger.error('Command `{}` failed'.format(command))
        return False
    return True


def get_command_output(command):
    """Run shell command and return its stdout"""

    result = subprocess.run(command, stdout=subprocess.PIPE)
    if result.returncode != 0:
        raise RuntimeError('Failed to run command: `{}`'.format(command))

    stdout = result.stdout.decode('utf-8')
    return stdout.strip()


def extract_to(targz_path, output_dir):
    tarfile.open(targz_path).extractall(output_dir)
