#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/config/include/config.h>

#include <maps/libs/common/include/exception.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/unittest/env.h>

namespace maps::fw_updater::config::tests {

TEST(ConfigTests, render_builtin_templated_configs) {
    vault_boy::MemoryContext ctx{
        {"POSTGRESQL_PASSWORD", "Db-Pass-Test-1"},
        {"S3_ACCESS_KEY_ID", "S3-Access-Key-Id-1"},
        {"S3_ACCESS_KEY_SECRET", "S3-Access-Key-Secret-1"},
        {"STORAGE_CLI_OAUTH_SECRET", "Storage-Cli-Oauth-Secret-1"},
        {"SIGNATURE_KEY", "Signature-Key-1"}
    };
    const std::string prefix = SRC_("../cfg");
    const auto ALL_CONFIG_FILES = {
        prefix + "/t-config.testing.xml",
        prefix + "/t-config.production.xml"
    };
    for (const auto& file: ALL_CONFIG_FILES) {
        Config cfg{ctx, file};
        SCOPED_TRACE(file);
        EXPECT_THAT(cfg.s3().accessKeyId(), "S3-Access-Key-Id-1");
        EXPECT_THAT(cfg.s3().accessKeySecret(), "S3-Access-Key-Secret-1");
        EXPECT_THAT(cfg.s3().connectTimeoutMs(), 10000);
        EXPECT_THAT(cfg.s3().requestTimeoutMs(), 300000);
        EXPECT_FALSE(cfg.storage().url().empty());
        EXPECT_THAT(cfg.storage().cli().oauthAppClientId(), "a151e6dcc9594ca199f210a73f370d6b");
        EXPECT_THAT(cfg.updater().signatureKey(), "Signature-Key-1");
    }
}

TEST(ConfigTests, read_templated_unittest_config) {
    vault_boy::MemoryContext ctx{
        {"POSTGRESQL_PASSWORD", "Db-Pass-Test"},
        {"S3_ACCESS_KEY_ID", "S3-Access-Key-Id"},
        {"S3_ACCESS_KEY_SECRET", "S3-Access-Key-Secret"},
        {"STORAGE_CLI_OAUTH_SECRET", "Storage-Cli-Oauth-Secret"},
        {"SIGNATURE_KEY", "Signature-Key"}
    };
    Config cfg{ctx};

    const auto& s3Conf = cfg.s3();
    EXPECT_THAT(s3Conf.bucket(), "maps-mrc-drive-package-testing");
    EXPECT_THAT(s3Conf.accessKeyId(), "S3-Access-Key-Id");
    EXPECT_THAT(s3Conf.accessKeySecret(), "S3-Access-Key-Secret");
    EXPECT_THAT(cfg.storage().cli().oauthAppClientId(), "a151e6dcc9594ca199f210a73f370d6b");
    EXPECT_THAT(cfg.storage().cli().oauthAppClientSecret(), "Storage-Cli-Oauth-Secret");
    EXPECT_THAT(cfg.updater().signatureKey(), "Signature-Key");
}

} // namespace maps::fw_updater::config::tests
