#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/enums.h>

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::fw_updater::db {
using namespace std::string_view_literals;

constexpr enum_io::Representations<Slot> SLOT_STRINGS{
    {Slot::Rootfs, "rootfs"sv},
    {Slot::Appfs, "appfs"sv},
    {Slot::MrcAppAllDc, "com.yandex.maps.mrcapp_all_dc"sv},
    {Slot::MrcAppManDc, "com.yandex.maps.mrcapp_man_dc"sv},
};

DEFINE_ENUM_IO(Slot, SLOT_STRINGS);

constexpr enum_io::Representations<RolloutStatus> ROLLOUT_STATUS_STRINGS{
    {RolloutStatus::Inactive, "inactive"sv},
    {RolloutStatus::Active, "active"sv},
};

DEFINE_ENUM_IO(RolloutStatus, ROLLOUT_STATUS_STRINGS);

} // namespace maps::fw_updater::db
