#pragma once

#include <maps/libs/sql_chemistry/include/gateway_access.h>

namespace maps::fw_updater::db {

class Branch {
public:
    Branch(std::string name)
        : name_(std::move(name))
    {}

    const std::string& name() const { return name_; }

private:
    friend class sql_chemistry::GatewayAccess<Branch>;

    Branch() = default;

    template <typename T>
    static auto introspect(T& t) { return std::tie(t.name_); }

    std::string name_;

public:
    auto introspect() const { return introspect(*this); }
};

using Branches = std::vector<Branch>;

} // namespace maps::fw_updater::db
