#pragma once

#include "branch.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db {

namespace table {
using namespace sql_chemistry;

struct Branch : Table<db::Branch> {

    static constexpr std::string_view name_{"firmware.branch"sv};

    static constexpr StringPrimaryKey name{"name"sv, name_};

    static constexpr auto columns_() { return std::tie(name); }
};

} // namespace table

using BranchGateway = sql_chemistry::Gateway<table::Branch>;

} // namespace maps::fw_updater::db
