#pragma once

#include "enums.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

namespace maps::fw_updater::db {

class DeviceBranch {
public:
    DeviceBranch(std::string hardwareId, std::string deviceId, std::string branch)
        : hardwareId_(std::move(hardwareId))
        , deviceId_(std::move(deviceId))
        , branch_(branch)
    {}

    const std::string& hardwareId() const { return hardwareId_; }

    const std::string& deviceId() const { return deviceId_; }

    const std::string& branch() const { return branch_; }

    DeviceBranch& setBranch(std::string branch)
    {
        branch_ = std::move(branch);
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<DeviceBranch>;

    DeviceBranch() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.hardwareId_, t.deviceId_, t.branch_);
    }

    std::string hardwareId_;
    std::string deviceId_;
    std::string branch_;

public:
    auto introspect() const { return introspect(*this); }
};

using DeviceBranches = std::vector<DeviceBranch>;

} // namespace maps::fw_updater::db
