#pragma once

#include "device_branch.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db {

namespace table {
using namespace sql_chemistry;

struct DeviceBranch : Table<db::DeviceBranch> {

    static constexpr std::string_view name_{"firmware.device_branch"sv};

    static constexpr StringPrimaryKey hardwareId{"hardware_id"sv, name_};
    static constexpr StringPrimaryKey deviceId{"device_id"sv, name_};
    static constexpr StringColumn branch{"branch"sv, name_};

    static constexpr auto columns_() { return std::tie(hardwareId, deviceId, branch); }
};

} // namespace table

using DeviceBranchGateway = sql_chemistry::Gateway<table::DeviceBranch>;

} // namespace maps::fw_updater::db
