#pragma once

#include "common.h"
#include "enums.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

namespace maps::fw_updater::db {

class Firmware {
public:
    Firmware(std::string hardwareId, Slot slot, std::string version,
             std::string url, size_t size, std::string md5)
        : hardwareId_(std::move(hardwareId))
        , slot_(slot)
        , version_(std::move(version))
        , url_(std::move(url))
        , size_(size)
        , md5_(std::move(md5))
    {}

    TId id() const { return id_; }

    const std::string& hardwareId() const { return hardwareId_; }

    Slot slot() const { return slot_; }

    const std::string& version() const { return version_; }

    size_t versionSeq() const { return versionSeq_; }

    const std::string& url() const { return url_; }

    size_t size() const { return size_; }

    const std::string& md5() const { return md5_; }

private:
    friend class sql_chemistry::GatewayAccess<Firmware>;

    Firmware() = default;

    template <typename T>
    static auto introspect(T& t)
    {
        return std::tie(t.id_, t.hardwareId_, t.slot_, t.version_, t.versionSeq_,
                        t.url_, t.size_, t.md5_);
    }

    TId id_{0};
    std::string hardwareId_;
    Slot slot_;
    std::string version_;
    size_t versionSeq_{0};
    std::string url_;
    size_t size_;
    std::string md5_;

public:
    auto introspect() const { return introspect(*this); }
};

using Firmwares = std::vector<Firmware>;

} // namespace maps::fw_updater::db
