#pragma once

#include "firmware.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db {

namespace table {
using namespace sql_chemistry;

struct Firmware : Table<db::Firmware> {

    static constexpr std::string_view name_{"firmware.firmware"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr StringColumn hardwareId{"hardware_id"sv, name_};
    static constexpr EnumColumn<Slot> slot{"slot"sv, name_};
    static constexpr StringColumn version{"version"sv, name_};
    static constexpr BigSerialKey versionSeq{"version_seq"sv, name_};
    static constexpr StringColumn url{"url"sv, name_};
    static constexpr NumericColumn<size_t> size{"size"sv, name_};
    static constexpr StringColumn md5{"md5"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, hardwareId, slot, version, versionSeq, url, size, md5);
    }
};

} // namespace table

using FirmwareGateway = sql_chemistry::Gateway<table::Firmware>;

} // namespace maps::fw_updater::db
