#pragma once

#include "firmware_upload.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db {

namespace table {
using namespace sql_chemistry;

struct FirmwareUpload : Table<db::FirmwareUpload> {

    static constexpr std::string_view name_{"firmware.firmware_upload"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr StringColumn hardwareId{"hardware_id"sv, name_};
    static constexpr EnumColumn<Slot> slot{"slot"sv, name_};
    static constexpr StringColumn version{"version"sv, name_};
    static constexpr TimePointColumn createdAt{"created_at"sv, name_};
    static constexpr StringColumn createdBy{"created_by"sv, name_};
    static constexpr StringColumn s3UploadId{"s3_upload_id"sv, name_};
    static constexpr StringColumn s3Key{"s3_key"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, hardwareId, slot, version, createdAt, createdBy,
                        s3UploadId, s3Key);
    }
};

} // namespace table

using FirmwareUploadGateway = sql_chemistry::Gateway<table::FirmwareUpload>;

} // namespace maps::fw_updater::db
