#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <utility>

namespace maps::fw_updater::db {

class FirmwareUploadPart {
public:
    FirmwareUploadPart(TId id, TId uploadId, size_t contentSize, std::string contentEtag)
        : id_(id)
        , uploadId_(uploadId)
        , contentSize_(contentSize)
        , contentEtag_(std::move(contentEtag))
    {}


    TId id() const { return id_; }

    TId uploadId() const { return uploadId_; }

    size_t contentSize() const { return contentSize_; }

    const std::string& contentEtag() const { return contentEtag_; }

    FirmwareUploadPart& setContentSize(size_t contentSize)
    {
        contentSize_ = contentSize;
        return *this;
    }

    FirmwareUploadPart& setContentEtag(std::string contentEtag)
    {
        contentEtag_ = std::move(contentEtag);
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<FirmwareUploadPart>;

    FirmwareUploadPart() = default;

    template <typename T>
    static auto introspect(T& t)
    {
        return std::tie(t.id_, t.uploadId_, t.contentSize_, t.contentEtag_);
    }

    TId id_;
    TId uploadId_;
    size_t contentSize_;
    std::string contentEtag_;

public:
    auto introspect() const { return introspect(*this); }
};

using FirmwareUploadParts = std::vector<FirmwareUploadPart>;

} // namespace maps::fw_updater::db
