#pragma once

#include "firmware_upload_part.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db {

namespace table {
using namespace sql_chemistry;

struct FirmwareUploadPart : Table<db::FirmwareUploadPart> {

    static constexpr std::string_view name_{"firmware.firmware_upload_part"sv};

    static constexpr Int64PrimaryKey id{"id"sv, name_};
    static constexpr Int64PrimaryKey uploadId{"upload_id"sv, name_};
    static constexpr Int64Column contentSize{"content_size"sv, name_};
    static constexpr StringColumn contentEtag{"content_etag"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, uploadId, contentSize, contentEtag);
    }
};

} // namespace table

using FirmwareUploadPartGateway = sql_chemistry::Gateway<table::FirmwareUploadPart>;

} // namespace maps::fw_updater::db
