#pragma once

#include "enums.h"
#include "common.h"

#include <maps/libs/json/include/value.h>
#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <optional>

namespace maps::fw_updater::db {

class Hardware {
public:
    const std::string& id() const { return id_; }

    TId idmProjectId() const { return idmProjectId_; }

    const std::optional<json::Value>& attrs() const { return attrs_; }

    Hardware& setAttrs(const json::Value& attrs)
    {
        attrs_ = attrs;
        return *this;
    }

    Hardware& clearAttrs()
    {
        attrs_ = std::nullopt;
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<Hardware>;

    Hardware() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.id_, t.idmProjectId_, t.attrs_);
    }

    std::string id_;
    TId idmProjectId_;
    std::optional<json::Value> attrs_;

public:
    auto introspect() const { return introspect(*this); }
};

using Hardwares = std::vector<Hardware>;

} // namespace maps::fw_updater::db
