#pragma once

#include "hardware.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db {

namespace table {
using namespace sql_chemistry;

struct Hardware : Table<db::Hardware> {

    static constexpr std::string_view name_{"firmware.hardware"sv};

    static constexpr StringPrimaryKey id{"id"sv, name_};
    static constexpr Int64Column idmProjectId{"idm_project_id"sv, name_};
    static constexpr Nullable<JsonColumn> attrs{"attrs"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, idmProjectId, attrs);
    }
};

} // namespace table

using HardwareGateway = sql_chemistry::Gateway<table::Hardware>;

} // namespace maps::fw_updater::db
