#pragma once

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <optional>

namespace maps::fw_updater::db::idm {

class Project {
public:
    TId id() const { return id_; }

    const std::string& key() const { return key_; }

    const std::string& nameRu() const { return nameRu_; }

    const std::string& nameEn() const { return nameEn_; }

    const std::string& slug() const { return slug_; }

    const std::string& slugNameRu() const { return slugNameRu_; }

    const std::string& slugNameEn() const { return slugNameEn_; }

    const std::optional<TId>& parentId() const { return parentId_; }

private:
    friend class sql_chemistry::GatewayAccess<Project>;

    Project() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.id_, t.key_, t.nameRu_, t.nameEn_,
                        t.slug_, t.slugNameRu_, t.slugNameEn_,
                        t.parentId_);
    }

    TId id_{0};
    std::string key_;
    std::string nameRu_;
    std::string nameEn_;
    std::string slug_;
    std::string slugNameRu_;
    std::string slugNameEn_;
    std::optional<TId> parentId_;

public:
    auto introspect() const { return introspect(*this); }
};

using Projects = std::vector<Project>;

} // namespace maps::fw_updater::db::idm
