#pragma once

#include "project.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db::idm {

namespace table {
using namespace sql_chemistry;

struct Project : Table<db::idm::Project> {

    static constexpr std::string_view name_{"idm.project"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr StringColumn key{"key"sv, name_};
    static constexpr StringColumn nameRu{"name_ru"sv, name_};
    static constexpr StringColumn nameEn{"name_en"sv, name_};
    static constexpr StringColumn slug{"slug"sv, name_};
    static constexpr StringColumn slugNameRu{"slug_name_ru"sv, name_};
    static constexpr StringColumn slugNameEn{"slug_name_en"sv, name_};
    static constexpr NullableInt64Column parentId{"parent_id"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, key, nameRu, nameEn, slug, slugNameRu, slugNameEn, parentId);
    }
};

} // namespace table

using ProjectGateway = sql_chemistry::Gateway<table::Project>;

} // namespace maps::fw_updater::db::idm
