#pragma once

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>

namespace maps::fw_updater::db::idm {

class ProjectRole {
public:
    TId id() const { return id_; }

    TId projectId() const { return projectId_; }

    TId roleId() const { return roleId_; }

private:
    friend class sql_chemistry::GatewayAccess<ProjectRole>;

    ProjectRole() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.id_, t.projectId_, t.roleId_);
    }

    TId id_;
    TId projectId_;
    TId roleId_;

public:
    auto introspect() const { return introspect(*this); }
};

using ProjectRoles = std::vector<ProjectRole>;

} // namespace maps::fw_updater::db::idm
