#pragma once

#include "project_role.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db::idm {

namespace table {
using namespace sql_chemistry;

struct ProjectRole : Table<db::idm::ProjectRole> {

    static constexpr std::string_view name_{"idm.project_role"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr Int64Column projectId{"project_id"sv, name_};
    static constexpr Int64Column roleId{"role_id"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, projectId, roleId);
    }
};

} // namespace table

using ProjectRoleGateway = sql_chemistry::Gateway<table::ProjectRole>;

} // namespace maps::fw_updater::db::idm
