#pragma once

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <optional>

namespace maps::fw_updater::db::idm {

class Role {
public:
    TId id() const { return id_; }

    const std::string& key() const { return key_; }

    const std::string& nameRu() const { return nameRu_; }

    const std::string& nameEn() const { return nameEn_; }

    const std::optional<std::string>& roleSet() const { return roleSet_; }

private:
    friend class sql_chemistry::GatewayAccess<Role>;

    Role() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.id_, t.key_, t.nameRu_, t.nameEn_, t.roleSet_);
    }

    TId id_{0};
    std::string key_;
    std::string nameRu_;
    std::string nameEn_;
    std::optional<std::string> roleSet_;

public:
    auto introspect() const { return introspect(*this); }
};

using Roles = std::vector<Role>;

} // namespace maps::fw_updater::db::idm
