#pragma once

#include "role.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db::idm {

namespace table {
using namespace sql_chemistry;

struct Role : Table<db::idm::Role> {

    static constexpr std::string_view name_{"idm.role"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr StringColumn key{"key"sv, name_};
    static constexpr StringColumn nameRu{"name_ru"sv, name_};
    static constexpr StringColumn nameEn{"name_en"sv, name_};
    static constexpr NullableStringColumn roleSet{"role_set"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, key, nameRu, nameEn, roleSet);
    }
};

} // namespace table

using RoleGateway = sql_chemistry::Gateway<table::Role>;

} // namespace maps::fw_updater::db::idm
