#pragma once

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>

namespace maps::fw_updater::db::idm {

class UserRole {
public:
    UserRole(std::string login, TId projectRoleId)
        : login_(std::move(login))
        , projectRoleId_(projectRoleId)
    {}

    const std::string& login() const { return login_; }

    TId projectRoleId() const { return projectRoleId_; }

private:
    friend class sql_chemistry::GatewayAccess<UserRole>;

    UserRole() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.login_, t.projectRoleId_);
    }

    std::string login_;
    TId projectRoleId_;

public:
    auto introspect() const { return introspect(*this); }
};

using UserRoles = std::vector<UserRole>;

} // namespace maps::fw_updater::db::idm
