#pragma once

#include "user_role.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db::idm {

namespace table {
using namespace sql_chemistry;

struct UserRole : Table<db::idm::UserRole> {

    static constexpr std::string_view name_{"idm.user_role"sv};

    static constexpr StringPrimaryKey login{"login"sv, name_};
    static constexpr Int64PrimaryKey projectRoleId{"project_role_id"sv, name_};

    static constexpr auto columns_() {
        return std::tie(login, projectRoleId);
    }
};

} // namespace table

using UserRoleGateway = sql_chemistry::Gateway<table::UserRole>;

} // namespace maps::fw_updater::db::idm
