#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>
#include <utility>

namespace maps::fw_updater::db {

class Rollout {
public:
    Rollout(std::string branch, TId firmwareId, std::string seed)
        : branch_(std::move(branch))
        , firmwareId_(firmwareId)
        , seed_(std::move(seed))
    {}

    TId id() const { return id_; }

    const std::string& branch() const { return branch_; }

    TId firmwareId() const { return firmwareId_; }

    const std::string& seed() const { return seed_; }

private:
    friend class sql_chemistry::GatewayAccess<Rollout>;

    Rollout() = default;

    template <typename T>
    static auto introspect(T& t)
    {
        return std::tie(t.id_, t.branch_, t.firmwareId_, t.seed_);
    }

    TId id_{0};
    std::string branch_;
    TId firmwareId_;
    std::string seed_;

public:
    auto introspect() const { return introspect(*this); }
};

using Rollouts = std::vector<Rollout>;

} // namespace maps::fw_updater::db
