#pragma once

#include "rollout.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db {

namespace table {
using namespace sql_chemistry;

struct Rollout : Table<db::Rollout> {

    static constexpr std::string_view name_{"firmware.rollout"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr StringColumn branch{"branch"sv, name_};
    static constexpr Int64Column firmwareId{"firmware_id"sv, name_};
    static constexpr StringColumn seed{"seed"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(id, branch, firmwareId, seed);
    }
};

} // namespace table

using RolloutGateway = sql_chemistry::Gateway<table::Rollout>;

} // namespace maps::fw_updater::db
