#pragma once

#include "common.h"
#include "enums.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/sql_chemistry/include/gateway_access.h>

namespace maps::fw_updater::db {

class RolloutHistory {
public:
    RolloutHistory(TId rolloutId, uint16_t percent, RolloutStatus status, std::string createdBy)
        : rolloutId_(rolloutId)
        , percent_(percent)
        , status_(status)
        , createdAt_(chrono::TimePoint::clock::now())
        , createdBy_(std::move(createdBy))
    {}

    TId id() const { return id_; }

    TId rolloutId() const { return rolloutId_; }

    uint16_t percent() const { return percent_; }

    bool isExperimental() const { return percent_ < 100; }

    RolloutStatus status() const { return status_; }

    chrono::TimePoint createdAt() const { return createdAt_; }

    const std::string& createdBy() const { return createdBy_; }

private:
    friend class sql_chemistry::GatewayAccess<RolloutHistory>;

    RolloutHistory() = default;

    template <typename T>
    static auto introspect(T& t)
    {
        return std::tie(t.id_, t.rolloutId_, t.percent_, t.status_, t.createdAt_, t.createdBy_);
    }

    TId id_{0};
    TId rolloutId_;
    uint16_t percent_;
    RolloutStatus status_;
    chrono::TimePoint createdAt_;
    std::string createdBy_;

public:
    auto introspect() const { return introspect(*this); }
};

using RolloutHistories = std::vector<RolloutHistory>;

} // namespace maps::fw_updater::db
