#pragma once

#include "rollout_history.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::fw_updater::db {

namespace table {
using namespace sql_chemistry;

struct RolloutHistory : Table<db::RolloutHistory> {

    static constexpr std::string_view name_{"firmware.rollout_history"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr Int64Column rolloutId{"rollout_id"sv, name_};
    static constexpr NumericColumn<uint16_t> percent{"percent"sv, name_};
    static constexpr EnumColumn<RolloutStatus> status{"status"sv, name_};
    static constexpr TimePointColumn createdAt{"created_at"sv, name_};
    static constexpr StringColumn createdBy{"created_by"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(id, rolloutId, percent, status, createdAt, createdBy);
    }
};

} // namespace table

using RolloutHistoryGateway = sql_chemistry::Gateway<table::RolloutHistory>;

} // namespace maps::fw_updater::db
