#include "fixture.h"

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/firmware_upload_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/firmware_upload_part_gateway.h>

#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/introspection/include/stream_output.h>

#include <library/cpp/testing/gtest/gtest.h>

namespace maps::fw_updater::db {
using introspection::operator==;
using introspection::operator!=;
using introspection::operator<<;
} // namespace maps::fw_updater::db

namespace maps::fw_updater::db::tests {

TEST_F(Fixture, test_firmware_upload)
{
    FirmwareUpload firmwareUpload{"login", "nanopi-neo4", Slot::Rootfs, "1.0.0"};
    firmwareUpload.setS3UploadId("s3-upload-id").setS3Key("nanopi-neo4-rootfs-1.0.0");
    FirmwareUploadParts firmwareUploadParts;

    {
        auto txn = txnHandle();
        FirmwareUploadGateway{*txn}.insert(firmwareUpload);

        firmwareUploadParts.emplace_back(1, firmwareUpload.id(), 16384, "etag-1");
        firmwareUploadParts.emplace_back(2, firmwareUpload.id(), 16384, "etag-2");

        FirmwareUploadPartGateway{*txn}.insert(firmwareUploadParts);
        txn->commit();
    }
    {
        auto txn = txnHandle();
        auto uploads = FirmwareUploadGateway{*txn}.load();
        ASSERT_EQ(uploads.size(), 1u);
        EXPECT_EQ(uploads[0], firmwareUpload);

        auto parts = FirmwareUploadPartGateway{*txn}.load(
            table::FirmwareUploadPart::uploadId == firmwareUpload.id(),
            sql_chemistry::orderBy(table::FirmwareUploadPart::id));
        ASSERT_EQ(parts.size(), 2u);
        EXPECT_EQ(parts, firmwareUploadParts);
    }
    {
        auto txn = txnHandle();
        firmwareUploadParts[1].setContentSize(32768).setContentEtag("new-etag-2");
        FirmwareUploadPartGateway{*txn}.update(firmwareUploadParts[1]);
        txn->commit();
    }
    {
        auto txn = txnHandle();
        auto part2 = FirmwareUploadPartGateway{*txn}.loadOne(
            table::FirmwareUploadPart::id == 2 &&
            table::FirmwareUploadPart::uploadId == firmwareUpload.id());
        EXPECT_EQ(part2, firmwareUploadParts[1]);
    }
}

} // namespace maps::fw_updater::db::tests
