#pragma once

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/unittest/include/database_fixture.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/unittest/env.h>

namespace maps::fw_updater::db::tests {

inline unittest::WithUnittestConfig<unittest::DatabaseFixture>& playground()
{
    static unittest::WithUnittestConfig<unittest::DatabaseFixture> global{};
    return global;
}


class Fixture : public testing::Test
{
public:
    Fixture()
    {
        playground().postgres().truncateTables();
        insertData();
    }

    pgpool3::Pool& pgPool() { return playground().pool(); }

    pgpool3::TransactionHandle txnHandle()
    {
        return pgPool().masterWriteableTransaction();
    }

private:
    void insertData()
    {
        auto txn = txnHandle();
        txn->exec(maps::common::readFileToString(SRC_("data.sql")));
        txn->commit();
    }
};

} // namespace maps::fw_updater::db::tests
