#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/unittest/include/database_fixture.h>

#include <maps/libs/config/include/config.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/libs/xml/include/xml.h>

#include <library/cpp/testing/unittest/env.h>

namespace maps::fw_updater::unittest {

namespace {

const std::string MIGRATIONS_PATH = (
    ArcadiaSourceRoot() +
    "/maps/wikimap/mapspro/services/mrc/drive/firmware_updater/migrations/migrations"
);

xml3::Node findDatabaseNode(const xml3::Doc& doc, const std::string dbId)
{
    return doc.node(
        "/config/databases/database[@id=\"" + dbId + "\"]"
    );
}

} // anonymous namespace

DatabaseFixture::DatabaseFixture(xml3::Doc& configDoc)
{
    postgres_.applyMigrations(MIGRATIONS_PATH);

    const std::string DATABASE_XPATH = "/config/databases/database";
    const std::string DATABASE_HOST_XPATH = DATABASE_XPATH + "/host";
    const std::string DB_ID = "core";
    const std::string POOL_ID = "core";

    auto databaseNode = configDoc.node(DATABASE_XPATH);
    databaseNode.setAttr("name", postgres_.dbname());
    auto node = configDoc.node(DATABASE_HOST_XPATH);
    node.setAttr("host", postgres_.host());
    node.setAttr("port", std::to_string(postgres_.port()));
    node.setAttr("user", postgres_.user());
    node.setAttr("password", postgres_.password());

    poolHolder_.reset(
        new wiki::common::PoolHolder(
            findDatabaseNode(configDoc, DB_ID), DB_ID, POOL_ID
        )
    );

    INFO() << "Testing DB connection string: '" << connStr() << "'";
}

pgpool3::Pool& DatabaseFixture::pool()
{
    return poolHolder_->pool();
}

std::string DatabaseFixture::connStr() const
{
    return postgres_.connectionString();
}

} // maps::fw_updater::unittest
