#pragma once

#include "unittest_config.h"

#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <maps/libs/xml/include/xml.h>
#include <maps/libs/config/include/config.h>
#include <maps/libs/local_postgres/include/instance.h>

#include <cstdint>
#include <string>
#include <vector>

namespace maps::fw_updater::unittest {

class DatabaseFixture
{
public:
    explicit DatabaseFixture(xml3::Doc& configDoc);
    virtual ~DatabaseFixture() = default;

    pgpool3::Pool& pool();

    std::string connStr() const;

    local_postgres::Database& postgres() { return postgres_; }

private:
    local_postgres::Database postgres_;
    std::unique_ptr<wiki::common::PoolHolder> poolHolder_;
};

} // namespace maps::fw_updater::unittest
