#pragma once

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/config/include/config.h>

#include <util/system/tempfile.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <filesystem>
#include <fstream>
#include <string>

namespace maps::fw_updater::unittest {

config::SharedXmlDoc readUnittestConfig();

// A wrapper intended to combine multiple test fixtures that modify and share
// the same config.
// It works in the following way.
// 1. An instance of UnittestConfig is created
// 2. This instance is copied to the private base of the wrapper and modified
//    by fixtures this wrapper consists of (not necessary in that order).
// 3. A Config instance which is read from the temporary config file
//    is cached in the config_ data member.
//
// WARNING: the order of base classes instantiation is not defined by the
// standard, so don't rely on it. I.e. you'll get into troubles if you try to
// pass the private UnittestConfig base to the base fixtures.
template <class... FTs>
class WithUnittestConfig : public FTs... {
public:
    // Each fixture must accept non-constant reference to xml3::Doc in
    // constructor and reset respective values.
    WithUnittestConfig(config::SharedXmlDoc doc = readUnittestConfig())
        : FTs(*doc)...
        , doc_(doc)
        // At this moment all base classes must have patched doc,
        // so it can be parsed.
        , config_(doc)
        , configPath_(MakeTempName().c_str())
    {
        std::ofstream file(configPath_);
        doc_->save(file);
    }

    ~WithUnittestConfig()
    {
        std::filesystem::remove_all(configPath_);
    }

    const config::Config& config() const
    {
        return config_;
    }

    const std::string& configPath() const
    {
        return configPath_;
    }

private:
    config::SharedXmlDoc doc_;
    config::Config config_;
    std::string configPath_;
};

/// Class for direct use as gtest fixture
template <class... FTs>
class WithUnittestConfigFixture : public testing::Test
                                , public WithUnittestConfig<FTs...>
{
};

} // namespace maps::fw_updater::unittest
