-- ALTER TYPE firmware.slot_t ADD VALUE 'appfs';
-- But enum type can't be altered in transaction block.
-- So instead of this command we need to define a new enum type
-- and migrate column to this type.

ALTER TYPE firmware.slot_t RENAME TO slot_t_old;

CREATE TYPE firmware.slot_t AS ENUM (
    'rootfs',
    'appfs'
);

ALTER TABLE firmware.firmware_upload
    ALTER COLUMN slot
    TYPE firmware.slot_t
    USING slot::text::firmware.slot_t;

ALTER TABLE firmware.firmware
    ALTER COLUMN slot
    TYPE firmware.slot_t
    USING slot::text::firmware.slot_t;

DROP TYPE firmware.slot_t_old;
