#pragma once

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/config/include/config.h>
#include <maps/libs/http/include/request.h>
#include <maps/libs/common/include/retry.h>

namespace maps::fw_updater::storage::cli {

class Context {
public:
    Context(const config::Config& config);

    http::URL baseUrl() const { return baseUrl_; }

    http::Client& httpClient() { return httpClient_; }

    const common::RetryPolicy& retryPolicy() const { return retryPolicy_; }

    std::function<bool(const Expected<http::Response>&)> responseValidator() const;

    std::function<std::string(const http::Response&)> errorReporter() const;

    const std::string& oauthHeader() const { return oauthHeader_; }

private:
    http::URL baseUrl_;
    http::Client httpClient_;
    maps::common::RetryPolicy retryPolicy_;
    std::string oauthHeader_;
};


void addAuth(http::Request& request, const Context& ctx);

std::string errorMessage(http::Response& response);

} // namespace maps::fw_updater::storage::cli
