#include "print.h"

#include <google/protobuf/io/zero_copy_stream_impl.h>
#include <google/protobuf/text_format.h>

#include <iostream>

namespace maps::fw_updater::storage::cli {

namespace {

void printIndented(std::ostream& out, const google::protobuf::Message& message, int indentLevel)
{
    google::protobuf::io::OstreamOutputStream stream(&out);
    google::protobuf::TextFormat::Printer printer;
    printer.SetInitialIndentLevel(indentLevel);
    printer.Print(message, &stream);
}

std::ostream& operator<< (std::ostream& out, const google::protobuf::Message& message)
{
    out << "{\n";
    printIndented(out, message, 1);
    out << "}\n";
    return out;
}

} // namespace

void print(const google::protobuf::Message& message)
{
    std::cerr << message;
}

} // namespace maps::fw_updater::storage::cli
