#include "tool.h"
#include "print.h"

#include <maps/libs/common/include/retry.h>
#include <maps/libs/http/include/request.h>
#include <maps/libs/common/include/file_utils.h>
#include <yandex/maps/proto/firmware_updater/storage/firmware.pb.h>
#include <yandex/maps/proto/firmware_updater/storage/upload.pb.h>

#include <fstream>

namespace proto = yandex::maps::proto::firmware_updater::storage;

namespace maps::fw_updater::storage::cli {

namespace {

void listFirmwareUploads(Context& ctx)
{
    http::URL url(ctx.baseUrl());
    url.setPath("/v2/firmware/upload/list");

    auto response = common::retry([&] {
            http::Request request(ctx.httpClient(), http::GET, url);
            addAuth(request, ctx);
            auto response = request.perform();
            return response;
        },
        ctx.retryPolicy(),
        ctx.responseValidator(),
        ctx.errorReporter());

    REQUIRE(response.responseClass() == http::ResponseClass::Success,
            errorMessage(response));
    proto::UploadsList uploadsList;
    Y_PROTOBUF_SUPPRESS_NODISCARD uploadsList.ParseFromString(TString(response.readBody()));
    print(uploadsList);
}


void deleteFirmwareUpload(Context& ctx, const std::string& uploadId)
{
    http::URL url(ctx.baseUrl());
    url.setPath("/v2/firmware/upload/delete").addParam("id", uploadId);

    auto response = common::retry([&] {
            http::Request request(ctx.httpClient(), http::DELETE, url);
            addAuth(request, ctx);
            auto response = request.perform();
            return response;
        },
        ctx.retryPolicy(),
        ctx.responseValidator(),
        ctx.errorReporter());

    REQUIRE(response.status() == 200, errorMessage(response));
}

} // namespace


void handleFirmwareUploadCommand(
    Context& ctx,
    const Options& options)
{
    ASSERT(options.command() == Command::FirmwareUpload);

    auto subCommand = options.subCommand<FirmwareUploadSubCommand>();
    switch(subCommand) {
        case FirmwareUploadSubCommand::List:
            listFirmwareUploads(ctx);
            break;
        case FirmwareUploadSubCommand::Delete:
            deleteFirmwareUpload(ctx, options.uploadId());
            break;
    }
}

} // namespace maps::fw_updater::storage::cli
