#include "common.h"
#include "idm/idm_service.h"

namespace maps::fw_updater::storage {

void checkAcl(pqxx::transaction_base& txn,
              const auth::UserInfo& userInfo,
              const db::Hardware& hardware)
{
    auto idmProjectId = hardware.idmProjectId();
    if (!idm::userHasRoleInProject(txn, userInfo.login(), "manager", idmProjectId)) {
        throw yacare::errors::Forbidden();
    }

}

} //namespace maps::fw_updater::storage
