#include "configuration.h"
#include <maps/libs/json/include/value.h>

#include <cstdlib>
#include <ctime>

namespace maps::fw_updater::storage {

constexpr auth::TvmId IDM_TVM_ID = 2001600;

Configuration::Configuration(config::Config cfg)
    : cfg_(std::move(cfg))
    , poolHolder_(cfg_.makePoolHolder())
    , idmTvmId_(IDM_TVM_ID)
    , s3Client_(cfg_.s3())
{
    std::srand(std::time(nullptr));
}

ConfigurationHolder& Configuration::instance()
{
    auto& instance = Configuration::instanceImpl();
    REQUIRE(instance, "Configuration instance is not initialized");
    return instance;
}

ConfigurationHolder Configuration::swap(ConfigurationHolder configuration)
{
    std::swap(instanceImpl(), configuration);
    return configuration;
}

ConfigurationHolder makeConfiguration(config::Config cfg)
{
    return std::make_unique<Configuration>(
        std::move(cfg));
}

} //namespace maps::fw_updater::storage
