#pragma once

#include "s3/client.h"

#include <maps/libs/auth/include/tvm.h>
#include <maps/libs/json/include/value.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/config/include/config.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <memory>

namespace maps::fw_updater::storage {

class Configuration;
using ConfigurationHolder = std::unique_ptr<Configuration>;

class Configuration
{
public:
    Configuration(config::Config cfg);

    static ConfigurationHolder& instance();

    static ConfigurationHolder swap(ConfigurationHolder configuration);

    const config::Config& config() const { return cfg_; }

    pgpool3::Pool& pool() { return poolHolder_.pool(); }

    auth::TvmId idmTvmId() const { return idmTvmId_; }

    s3::S3Client& s3Client() { return s3Client_; }

private:
    static ConfigurationHolder& instanceImpl()
    {
        static ConfigurationHolder instance_;
        return instance_;
    }

    config::Config cfg_;
    wiki::common::PoolHolder poolHolder_;
    auth::TvmId idmTvmId_;
    s3::S3Client s3Client_;
};

ConfigurationHolder makeConfiguration(config::Config cfg);

inline ConfigurationHolder& configuration()
{
    return Configuration::instance();
}

} //namespace maps::fw_updater::storage
