#include "error_reporter.h"

#include <maps/libs/sql_chemistry/include/exceptions.h>
#include <maps/libs/log8/include/log8.h>

#include <pqxx/except>

namespace maps::fw_updater::storage {

void errorReporter(const yacare::Request&, yacare::Response& resp)
{
    try {
        throw;
    }
    catch (const yacare::Error& e) {
        resp.setStatus(yacare::HTTPStatus::find(e.status()));
        resp << e.what();
        ERROR() << e;
    }
    catch (const maps::sql_chemistry::ObjectNotFound& e) {
        resp.setStatus(yacare::HTTPStatus::NotFound);
        resp << e.what();
        ERROR() << e;
    }
    catch (const pqxx::plpgsql_raise& e) {
        resp.setStatus(yacare::HTTPStatus::BadRequest);
        resp << e.what();
        ERROR() << e.what();
    }
    catch (const maps::Exception& e) {
        resp.setStatus(yacare::HTTPStatus::InternalError);
        resp << e.what();
        ERROR() << e;
    }
    catch (const std::exception& e) {
        resp.setStatus(yacare::HTTPStatus::InternalError);
        resp << e.what();
        ERROR() << "Internal error: " << e.what();
    }
}

} //namespace maps::fw_updater::storage
