#include "common.h"

#include <util/string/split.h>
#include <ostream>
#include <sstream>

namespace maps::fw_updater::storage::idm {

std::string toString(const SlugPath& path)
{
    std::stringstream stream;
    for (auto& elem : path) {
        stream << "/" << elem.slug << "/" << elem.key;
    }
    return stream.str();
}

SlugPath parseSlugPath(const std::string& path)
{
    SlugPath result;

    auto tokens = StringSplitter(path).Split('/').SkipEmpty().ToList<std::string>();
    if (tokens.size() % 2) {
        throw BadParameter() << "Odd number of tokens in slug path " << path;
    }

    for (size_t i = 0; i < tokens.size(); i += 2) {
        result.push_back({std::move(tokens[i]), std::move(tokens[i+1])});
    }
    return result;
}

std::ostream& operator<<(std::ostream& os, const SlugPath& path)
{
    return os << toString(path);
}

} //namespace maps::fw_updater::storage::idm
