#pragma once

#include <maps/wikimap/mapspro/services/mrc/drive/firmware_updater/libs/db/include/common.h>

#include <maps/libs/common/include/exception.h>
#include <maps/libs/introspection/include/comparison.h>

#include <string>
#include <vector>

namespace maps::fw_updater::storage::idm {

using Id = db::TId;
using Ids = std::vector<Id>;
using Login = std::string;

class BadParameter : public maps::Exception {
    using Exception::Exception;
};

struct PathElem
{
    std::string slug;
    std::string key;

    auto introspect() const { return std::tie(slug, key); }
};

using SlugPath = std::vector<PathElem>;
using SlugPaths = std::vector<SlugPath>;

std::string toString(const SlugPath& path);

SlugPath parseSlugPath(const std::string& path);

std::ostream& operator<<(std::ostream& os, const SlugPath& path);

} //namespace maps::fw_updater::storage::idm
